function [propdata] = collate_propfiles(varargin)
%A function that pulls specific property files from collated class folders,
%and joins them for analysis and presentation.  For example: you can pull 
%all median_col_sum_prop files from the sum_collated folders of each 
%synapse class to assess median values across the dataset.  Only works in
%collated class folders.
%Synatax:   [sumdata] = collate_propfiles('dir','c:\...','dirout','c:\...')
%Input:     'dir' = the collated folders containing each synapse class
%           'dirout' = where the collated files are saved out
%           'type' = the property type, it is a string that will be used to
%               match files in the file directory, e.g., 'median'
%           'prop_dir' = the property directory where the files are held,
%               default = 'sum_collated'
%           'spacernum' = the spacer number between datapoints, default = 2
%Output:    propdata = Not sure there is an output yet.

[dir1,dirout,prop_dir,type,spacernum] = parse(varargin);  %parse the input

%Now dive into the directory structure
dir_struct = dir(dir1);  %grab the directory information
idx = [dir_struct.isdir];   %grab all of the isdir numbers
names = {dir_struct.name};   %grab the all of the names in the root
root_dirnames = names(idx);
%make the output directory
mkdir(dirout);

%go through each class structure
for i = 3:size(root_dirnames,2)
    %this level is the exp condition level, e.g., KO vs. WT
    exp_dir = [dir1,filesep,root_dirnames{i}];  %current directory
    %we are coding this dead for KO and WT right now, if you want to open
    %this up to be more flexible or to use another number of set
    %experimental conditions, you will need to edit 'WT' and 'KO' and you
    %will need to edit join_sumfiles first.
%     %grab directory information
%     exp_dir_struct = dir(exp_dir);  %grab the directory information
%     idx = [exp_dir_struct.isdir];   %grab all of the isdir numbers
%     names = {exp_dir_struct.name};   %grab the all of the names in the root
%     exp_dirnames = names(idx);
%     for j = 3:size(exp_dirnames,2)
%         %this level is the region level, e.g., layer 4 vs. layer 5
%         reg_dir = [exp_dir,filesep,exp_dirnames{j}];  %current directory
        exp_dirnames = {'KO';'WT'};     %just a note on the HARDCODE
        reg_dir = [exp_dir,filesep,'KO'];  %use region from the first experimental condition as default
        reg_dir2 = [exp_dir,filesep,'WT'];  %the HARDCODED second region, yo
        %grab directory information
        reg_dir_struct = dir(reg_dir);  %grab the directory information
        idx = [reg_dir_struct.isdir];   %grab all of the isdir numbers
        names = {reg_dir_struct.name};   %grab the all of the names in the root
        reg_dirnames = names(idx);
        for k = 3:size(reg_dirnames,2)
            %now we drill down to the file level
            %currently we are focused on aprop, switch to prop if you use S variant analysis
            file_dir = [reg_dir,filesep,reg_dirnames{k},filesep,'aprop',filesep,prop_dir]; %default
            file_dir2 = [reg_dir2,filesep,reg_dirnames{k},filesep,'aprop',filesep,prop_dir];  %the other HARDCODED recond region, yo
            %grab file information
            file_dir_struct = dir(file_dir);  %grab the directory information
            idx = [file_dir_struct.isdir];   %grab all of the isdir numbers
            names = {file_dir_struct.name};   %grab the all of the names in the root
            filenames = names(~idx);    %filenames
            %find the correct type files
            match_files = {}; %initiate
            for l = 1:size(filenames,2)     
                stridx = isstrprop(filenames{l},'punct');
                stridx = find(stridx==1);   %the first '_' is the one
                if strcmp(type,filenames{l}(1:stridx(1)-1)) %first step
                        match_files = vertcat(match_files,filenames{l});
                end
            end
            %lets create the output directory now
            dirout_tmp = [dirout,filesep,reg_dirnames{k}];
            if i==3     %only need to do this once
            mkdir(dirout,reg_dirnames{k});  %make directory
            end
            %go through each property type, as each match file should be a
            %specific property
            for m = 1:size(match_files,1)
                %output label text
                labeltxt = [root_dirnames{i},'_',num2str(m),'_'];
                join_sumfiles('path1',file_dir,'file1',match_files{m},'path2',file_dir2,'file2',match_files{m},...
                    'output_path',dirout_tmp,'output_file',type,'spacernum',spacernum,'label',labeltxt);
            end
        end
    %end
end

%save out some other files
sav2csv(root_dirnames','syn_class_list.csv',dirout);
sav2csv(exp_dirnames','experimental_conditions.csv',dirout);
sav2csv(reg_dirnames','regions_tested.csv',dirout);
propdata.synclass = root_dirnames;
propdata.expconditions = exp_dirnames;
propdata.regions = reg_dirnames;


%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [dir1,dirout,prop_dir,type,spacernum] = parse(input)

dir1 = [];
dirout = [];
prop_dir = 'sum_collated';  %default grab values from sum_collated
type = 'median';    %default median
spacernum = 2;

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'dir'
                    dir1 = input{1,i+1};
                case 'dirout'
                    dirout = input{1,i+1};
                case 'prop_dir'
                    prop_dir = input{1,i+1};
                case 'type'
                    type = input{1,i+1};
                case 'spacernum'
                    spacernum = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

if isempty(dir1)   %get class directory
    [dir1] = uigetdir2('','Directory where the files are located');
end
if isempty(dirout) %create output directory
    %if user did not specify dirout, it will default to the root directory
    %above the classes
    dirout = [dir1,filesep,['collated_',type,'_data']];
end